# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 7
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR7_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR7(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Check for deterministic opponent strategies
    always_cooperate = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code.lower()
    always_defect = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code.lower()
    
    if always_cooperate:
        return "D"
    if always_defect:
        return "D"
    
    if current_round == 1:
        return "C"
    
    # Initial rounds (1-3)
    if current_round <= 3:
        if "D" in opp_history:
            return opp_history[-1]  # Tit-for-Tat
        else:
            return "C"
    
    # Middle rounds (4-7)
    if current_round <= 7:
        if opp_history.count("D") > 1:
            # Tit-for-Two-Tats: defect only after two consecutive defections
            if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
                return "D"
            else:
                return "C"
        else:
            return "C"
    
    # Final rounds (8-10)
    if opp_history.count("D") >= 3:
        return "D"
    else:
        return "C"